#join ALLORG.gz date, login, release with cleanMrComment.gz,
#with alldelta.clean.gz

require "timelocal.pl";

#first paste MR number with cleaned comment
open (A, 'gunzip < decay/ALLMR.gz | cut -d\; -f1 |');
open (B, "gunzip < cleanMrComment.gz |");
while (<A>){
	chop ($_);
	$x = <B>;
	$x =~ s/\;/ /g;#make sure no separators present
	chop ($x);
	$MR{$_} = $x;
	#print "$_:" . $MR{$_} . "\n";
}
close (A);
close (B);
print STDERR "done ALLMR\n";
open (A, 'gunzip < allmrs.clean.b.gz | cut -d\; -f1,17 |');
while (<A>){
	chop ($_);
	@x = split (/\;/, $_);
	$MRBNC{$x[0]} = $x[1];
}
close (A);
print STDERR "done bnc\n";

open (A, 'gunzip < decay/ALLORG.gz | cut -d\; -f1,2,3,9 |');
while (<A>){
	chop ($_);
	@x=split(/\;/, $_);
	if ($MR{$x[0]} eq ""){
		print STDERR "no MR $x[0] from ORG relation in MR relation\n";
	}else{
		$yy = $MR{$x[0]};
		@y = split (/\;/, $yy);
		if (scalar (@y) > 1){
			#print STDERR "MR $x[0] has been encountered before\n";
		}else{
			# to timestamp $x[3]
			$x[3] =~ s/ /\;/go;
			$x[3] =~ s/\:/\;/go;
			$x[3] =~ s/\//\;/go;
			@y=split(/\;/, $x[3]);
			$timest = &timelocal(($y[5], $y[4], $y[3], $y[2], $y[1]-1, $y[0]));
			
			$MR{$x[0]} = $MR{$x[0]} . "\;" . $x[1] . "\;" . $x[2] . "\;" . $timest;
		}	
	}
}
close (A);
print STDERR "done ORG\n";

open (A, 'gunzip < decay/alldelta2.clean.gz |');
while (<A>){
	chop ($_);
	@x = split(/\;/, $_);
	$mr=$x[12];

	#find starting, ending delta
	$ymd = $x[1] .":". $x[2] .":". $x[3];
	$hr = $x[4];
	$stmp = &timelocal (($x[6],$x[5],$x[4],$x[3],$x[2]-1,$x[1]));
	if ($MRSTART{$mr} eq ""){
		$MRSTART{$mr} = $stmp;
		$MREND{$mr} = $stmp;
	}else{
		if ($MRSTART{$mr} > $stmp){
			$MRSTART{$mr} = $stmp;
		}
		if ($MREND{$mr} < $stmp){
			$MREND{$mr} = $stmp;
		}
	}
	
	#imr stamp + bug/new
	if ($x[17] eq "-1"){
		$imrstamp = 0;
	}else {
		if ($x[17] =~ /(\d\d)(\d\d)(\d\d)/ && $1 > 0 && $1 < 13){
			$imrstamp = &timelocal ((0,0,0, $2, $1-1, $3));
			$imrymd = $3 .":". $2 .":". $1;
		}else{
			print STDERR "bad IMR date $1:$2:$3 at line $.\n";
			$imrstamp = 0;
		}
	}
   $MRIMR{$mr} = $imrstamp . "\;" . $x[16] . "\;" . $x[18]. "\;" . $x[19]. "\;" . $x[20] . "\;" . $x[21] . "\;" . $x[22] ."\;" . $x[23];
	

	#get size info
	$MRCOUNT{$mr} ++;
	$MRADD{$mr} += $x[8];
	$MRDEL{$mr} += $x[9];
	$MRSAM{$mr} += $x[10];

	#get file info
	if ($x[13] ne ""){
		$fff = $x[13] .".". $x[14];
		if ($MRFILES{$mr} eq ""){
			$MRFILES{$mr} = $fff;
		}else{
			if ($MRFILES{$mr} =~ m/$fff/){}
			else{
				$MRFILES{$mr} = $MRFILES{$mr} . "\:" . $fff;
			}
		}
	}
	
	if ($x[15] ne ""){
		$x[15] =~ s/\//_/;
		if ($MRMODULES{$mr} eq ""){
			$MRMODULES{$mr} = $x[15];
		}else{
			if ($MRMODULES{$mr} =~ /$x[15]/){}
			else{	$MRMODULES{$mr} = $MRMODULES{$mr} . "\:"  . $x[15];}
		}
	}
	
	if ($x[14] ne ""){
		if ($MRTYPES{$mr} eq ""){
			$MRTYPES{$mr} = $x[14];
		}else{
			if ($MRTYPES{$mr} =~ /$x[14]/){}
			else{	$MRTYPES{$mr} = $MRTYPES{$mr} . "\:"  . $x[14];}
		}
	}
	
}
close (A);

print STDERR "done delta\n";


for $i (keys %MR){
	if ($MRIMR{$i} =~ /\;/){}else{$MRIMR{$i} = "\;\;\;\;\;\;\;"; }
	if (scalar (split (/\;/, $MR{$i})) < 4) {$MR{$i} = "\;\;\;"; }
	print "$i\;" . $MR{$i} . "\;" . $MRIMR{$i} . "\;"
		. $MRSTART{$i} . "\;" . $MREND{$i} ."\;"
			. $MRCOUNT{$i} . "\;" .$MRADD{$i} . "\;" . $MRDEL{$i} . "\;" 
	. $MRSAM{$i} . "\;"
		 . $MRMODULES{$i} . "\;" . $MRFILES{$i} . "\;" . $MRTYPES{$i};
	if ($MRBNC{$i} eq ""){
		print ";-1";
	}else{
		print ";$MRBNC{$i}";
	}
	print "\n";
}

print STDERR "FINISHED\n";

#0  - MR                      
#1  - Comment                 
#2  - Project                 
#3  - developer               
#4  - openMRdate              
#5  - openImrdate             
#6  - IMR BugNew
#7  - IMR release
#8  - IMR found during
#9  - IMR priority
#10 - IMR originated during
#11 - IMR type (sw, hw ...)
#12 - IMR SU load
#13 - firstDelta              
#14 - lastDelta               
#15 - numDelta                
#16 - linesAdded              
#17 - linesDeleted            
#18 - lines                                  Unchanged          
#19 - moduleList (: separated)
#20 - fileList                
#21 - extensionList           
#22 - bnci






